/**
  Copyright (c) 2012 Freescale Semiconductor
  
  \file       mc_tabs.c
  \brief      This file contains the animations
  \author     Freescale Semiconductor
  \author     Automotive Systems Solutions Engineering
  \author     DB, r54930
  \version    1.0
  \date       16/Feb/2014
  
  * History:  16/Feb/2014- Initial Version

* Copyright (c) 2014, Freescale, Inc.  All rights reserved.
*
*
* No part of this document must be reproduced in any form - including copied,
* transcribed, printed or by any electronic means - without specific written
* permission from Freescale Semiconductor.
*
   
*/

#include "common.h"
#include "..\HIL\Graphics.h"
#include "..\HIL\Display.h"
#include "..\HIL\Flib.h"
#include "..\HAL\GALLO.h"
#include "..\SERVICES\DMAHandler.h"
#include "..\HIL\FontLibrary.h"
#include "mc_parameters.h"
#include "..\src\FSLtime.h"
// Image objects
#include "..\PICTURES\Tabs\tabO.h"
#include "..\PICTURES\Tabs\Icons.h"
#include "..\PICTURES\Tabs\Gear.h"
#include "..\PICTURES\Tabs\seatBelt.h"
// Fonts
#include "..\FONTS\ARIAL34.h"
#include "..\FONTS\ARIAL30.h"


/************/
/*  Defines */
/************/

/***********************************/
// ********  Constants  ************
/**********************************/

/********************/
/* Global Variables */
/********************/

/*********************************/
/* Function prototypes ***********/
/*********************************/

/*******************************/
/*  Code starts Here           */
/*******************************/
void mc_tabs(uint32_t CurrentFrame)
{
    uint32_t relative_fr;
    uint32_t temp32;
    uint8_t dmachnl;
    Graphics_ErrorType Gret;
    
    if(mc_tabs_properties.frameLatch == 0u)
    {
        mc_tabs_properties.frameLatch = CurrentFrame;
    }
    relative_fr = CurrentFrame - mc_tabs_properties.frameLatch;
    
// Init objects     
    switch(relative_fr)
    {
      // We start by initializing all the graphics objects by copy to RAM.
      // In a Halo device this is potentuially not necassary because we can just leave them in FLASH.
      case 0:
      break;
      default:
      break;
    }

/**********************************************/
void mc_tabs_Dispose()
{
	
}

void mc_tabs_Refresh()
{

}
